%fonction gnration de profils de vitesse
% Le vecteur q contient les consignes angulaires de chaque axe. format :
% exemple : q=[10 2 50 ] --> rotation de 10 degrs sur l'axe 1, 2
% degrs surl'axe 2, etc...
% la structure rob contient les donnes suivantes :
%rob.max_vit =vecteur 1x3 contenant les vitesses maximales atteignables par
%chaque axe en deg/s
%rob.max_acc =vecteur 1x3 contenant les acclrations maximales atteignables par
%chaque axe en deg/s
%per=[1 1] pourcentage de vitesse et d'acclration max pour les axes

%Fs est la frquence d'chantillonnage. 

function res=gene_consignes_3axes(q,rob,Fs,per)

%% Vitesses et acclrations max en fonction des paramtres robot

    cur_vit=per(1)*rob.vmax;
    cur_acc=per(2)*rob.amax;

%% Temps maximal du palier de vitesse
    tmax=(abs(q)-(cur_vit.^2)./cur_acc)./cur_vit;
    %tmax=(abs(q)-cur_vit.*cur_vit./cur_acc)./cur_vit;
    [ti,i]=max(tmax);
   disp(tmax);
%% Gnration des profils
mult=sign(q);

disp(mult)
if ti>=0
    % Calculer le temps d'acclration ncessaire sur l'axe le plus "lent"
 tacc=cur_vit(i)/cur_acc(i);

    % Calculer la vitesse max sur chaque axe
    vit=q/(ti+tacc);
    % Calculer l'acclration sur chaque axe
    acc=vit/tacc;
    % Initialisation boucle de gnration du profil
    k=0; % temps
    i=1; % index
    dk=1/Fs; % pas de temps
    while k<=(2*tacc+ti)
       if k==0 % init
 
        res.prof(i,1)=k;
        res.prof(i,2)=0;
        res.prof(i,3)=0;
        res.prof(i,4)=0;
 

        i=i+1;
        k=k+dk;
       elseif k<=(tacc+dk) % rampe
        res.prof(i,1)=k;
        res.prof(i,2)=(res.prof(i-1,2)+dk*acc(1));
        res.prof(i,3)=(res.prof(i-1,3)+dk*acc(2));
        res.prof(i,4)=(res.prof(i-1,4)+dk*acc(3));
 

        i=i+1;
        k=k+dk;
        
        elseif (k>(tacc+dk)) && (k<=(tacc+ti)) % palier
        res.prof(i,1)=k;
        res.prof(i,2)=res.prof(i-1,2);
        res.prof(i,3)=res.prof(i-1,3);
        res.prof(i,4)=res.prof(i-1,4);


        i=i+1;
        k=k+dk;
        
       else % rampe
        res.prof(i,1)=k;
        res.prof(i,2)=(res.prof(i-1,2)-dk*acc(1));
        res.prof(i,3)=(res.prof(i-1,3)-dk*acc(2));
        res.prof(i,4)=(res.prof(i-1,4)-dk*acc(3));


        i=i+1;
        k=k+dk;
       end
    end
      for i=1:numel(mult)

if mult(i)==-1 % Si l'angle est ngatif, inverser le trapze
    res.prof(:,i+1)=-1*res.prof(:,i+1);
elseif mult(i)==0 % si l'angle est nul, s'assurer que la commande est nulle
    res.prof(:,i+1)=0;
end
  end

else
% Si le temps max de palier est ngatif, gnrer un Bang Bang sans palier
    tacci=sqrt(abs(q)./cur_acc)
    %tacci=sqrt(q/cur_acc);
    tacc=max(tacci);
    disp(tacc);
  
    % Calculer l'acclration sur les axes
    acc=q/(tacc^2);
    % Initialisation boucle de gnration du profil
    k=0; %temps
    i=1; %index
    dk=1/Fs; % pas de temps
    while k<(2*tacc)
        
        if k==0 %init
        res.prof(i,1)=k;
        res.prof(i,2)=0;
        res.prof(i,3)=0;
        res.prof(i,4)=0;


        i=i+1;
        k=k+dk;
           elseif k<tacc % rampe
        res.prof(i,1)=k;
        res.prof(i,2)=(res.prof(i-1,2)+dk*acc(1));
        res.prof(i,3)=(res.prof(i-1,3)+dk*acc(2));
        res.prof(i,4)=(res.prof(i-1,4)+dk*acc(3));


        i=i+1;
        k=k+dk;
        else % rampe
            res.prof(i,1)=k;
        res.prof(i,2)=(res.prof(i-1,2)-dk*acc(1));
        res.prof(i,3)=(res.prof(i-1,3)-dk*acc(2));
        res.prof(i,4)=(res.prof(i-1,4)-dk*acc(3));


        i=i+1;
        k=k+dk;
        end
    end
    
      for i=1:numel(mult)

if mult(i)==-1 % si l'angle est ngatif
    res.prof(:,i+1)=-1*res.prof(:,i+1);
elseif mult(i)==0 % si l'angle est nul
    res.prof(:,i+1)=0;
end
  end

end

  for i=1:numel(mult)

if mult(i)==-1
    res.prof(:,i+1)=-1*res.prof(:,i+1);
elseif mult(i)==0
    res.prof(:,i+1)=0;
end
  end


close all;
figure;
    %tracer les consignes gnres sur les 6 axes.
hold on;
grid on;
plot(res.prof(:,1),res.prof(:,2),'b','LineWidth',3);
plot(res.prof(:,1),res.prof(:,3),'r','LineWidth',3);
plot(res.prof(:,1),res.prof(:,4),'g','LineWidth',3);

    legend('Axe 1','Axe 2','Axe 3');
    title('Profils en vitesse','fontsize',20,'FontName','Times New Roman')
xlabel('Temps (s)','fontsize',20,'FontName','Times New Roman')
ylabel('Vitesse (/s)','fontsize',20,'FontName','Times New Roman')
%else
    

%end


end